"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, product_type: str, e164_phone_numbers: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.

    Args:
        product_type(str): The phone number product type.
        e164_phone_numbers(List): List of phone numbers, in E.164 format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.order.create(
                ctx, product_type=value, e164_phone_numbers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.order.create product_type=value, e164_phone_numbers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_phone_number_order",
        op_kwargs={"ProductType": product_type, "E164PhoneNumbers": e164_phone_numbers},
    )


async def get(hub, ctx, phone_number_order_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.

    Args:
        phone_number_order_id(str): The ID for the phone number order.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.order.get(ctx, phone_number_order_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.order.get phone_number_order_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_phone_number_order",
        op_kwargs={"PhoneNumberOrderId": phone_number_order_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the phone number orders for the administrator's Amazon Chime account.

    Args:
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.order.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.order.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_phone_number_orders",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
