"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, phone_number_id: str) -> None:
    r"""
    **Autogenerated function**

    Moves the specified phone number into the Deletion queue. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted. Deleted phone numbers remain in the Deletion queue for 7 days before they are deleted permanently.

    Args:
        phone_number_id(str): The phone number ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.init.delete(ctx, phone_number_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.init.delete phone_number_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_phone_number",
        op_kwargs={"PhoneNumberId": phone_number_id},
    )


async def get(hub, ctx, phone_number_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.

    Args:
        phone_number_id(str): The phone number ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.init.get(ctx, phone_number_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.init.get phone_number_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_phone_number",
        op_kwargs={"PhoneNumberId": phone_number_id},
    )


async def list_all(
    hub,
    ctx,
    status: str = None,
    product_type: str = None,
    filter_name: str = None,
    filter_value: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.

    Args:
        status(str, optional): The phone number status. Defaults to None.
        product_type(str, optional): The phone number product type. Defaults to None.
        filter_name(str, optional): The filter to use to limit the number of results. Defaults to None.
        filter_value(str, optional): The value to use for the filter. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_phone_numbers",
        op_kwargs={
            "Status": status,
            "ProductType": product_type,
            "FilterName": filter_name,
            "FilterValue": filter_value,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def restore(hub, ctx, phone_number_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Moves a phone number from the Deletion queue back into the phone number Inventory.

    Args:
        phone_number_id(str): The phone number.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.init.restore(ctx, phone_number_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.init.restore phone_number_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="restore_phone_number",
        op_kwargs={"PhoneNumberId": phone_number_id},
    )


async def update(
    hub, ctx, phone_number_id: str, product_type: str = None, calling_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type. Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.

    Args:
        phone_number_id(str): The phone number ID.
        product_type(str, optional): The product type. Defaults to None.
        calling_name(str, optional): The outbound calling name associated with the phone number. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.init.update(ctx, phone_number_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.init.update phone_number_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_phone_number",
        op_kwargs={
            "PhoneNumberId": phone_number_id,
            "ProductType": product_type,
            "CallingName": calling_name,
        },
    )
