"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def disassociate(
    hub, ctx, voice_connector_id: str, e164_phone_numbers: List
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.

    Args:
        voice_connector_id(str): The Amazon Chime Voice Connector ID.
        e164_phone_numbers(List): List of phone numbers, in E.164 format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.from_.voice_connector.init.disassociate(
                ctx, voice_connector_id=value, e164_phone_numbers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.from_.voice_connector.init.disassociate voice_connector_id=value, e164_phone_numbers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="disassociate_phone_numbers_from_voice_connector",
        op_kwargs={
            "VoiceConnectorId": voice_connector_id,
            "E164PhoneNumbers": e164_phone_numbers,
        },
    )
