"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, account_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the primary provisioned phone number from the specified Amazon Chime user.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.phone_number.from_.user.disassociate(
                ctx, account_id=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.phone_number.from_.user.disassociate account_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="disassociate_phone_number_from_user",
        op_kwargs={"AccountId": account_id, "UserId": user_id},
    )
