"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def reset(hub, ctx, account_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.

    Args:
        account_id(str): The Amazon Chime account ID.
        user_id(str): The user ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.personal_pin.reset(ctx, account_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.personal_pin.reset account_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="reset_personal_pin",
        op_kwargs={"AccountId": account_id, "UserId": user_id},
    )
