"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    client_request_token: str,
    external_meeting_id: str = None,
    meeting_host_id: str = None,
    media_region: str = None,
    tags: List = None,
    notifications_configuration: Dict = None,
    attendees: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see Amazon Chime SDK Media Regions in the Amazon Chime Developer Guide . For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide .

    Args:
        client_request_token(str): The unique identifier for the client request. Use a different token for different meetings.
        external_meeting_id(str, optional): The external meeting ID. Defaults to None.
        meeting_host_id(str, optional): Reserved. Defaults to None.
        media_region(str, optional):  The Region in which to create the meeting. Default: us-east-1 .   Available values: af-south-1 , ap-northeast-1 , ap-northeast-2 , ap-south-1 , ap-southeast-1 , ap-southeast-2 , ca-central-1 , eu-central-1 , eu-north-1 , eu-south-1 , eu-west-1 , eu-west-2 , eu-west-3 , sa-east-1 , us-east-1 , us-east-2 , us-west-1 , us-west-2 . . Defaults to None.
        tags(List, optional): The tag key-value pairs. Defaults to None.
        notifications_configuration(Dict, optional):  The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (us-east-1). . Defaults to None.
        attendees(List, optional): The request containing the attendees to create. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.with_attendee.create_multiple(
                ctx, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.with_attendee.create_multiple client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_meeting_with_attendees",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "ExternalMeetingId": external_meeting_id,
            "MeetingHostId": meeting_host_id,
            "MediaRegion": media_region,
            "Tags": tags,
            "NotificationsConfiguration": notifications_configuration,
            "Attendees": attendees,
        },
    )
