"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, meeting_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags applied to an Amazon Chime SDK meeting resource.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.tag.list_all(ctx, meeting_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.tag.list_all meeting_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_meeting_tags",
        op_kwargs={"MeetingId": meeting_id},
    )
