"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_request_token: str,
    external_meeting_id: str = None,
    meeting_host_id: str = None,
    media_region: str = None,
    tags: List = None,
    notifications_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see Amazon Chime SDK Media Regions in the Amazon Chime Developer Guide . For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide .

    Args:
        client_request_token(str): The unique identifier for the client request. Use a different token for different meetings.
        external_meeting_id(str, optional): The external meeting ID. Defaults to None.
        meeting_host_id(str, optional): Reserved. Defaults to None.
        media_region(str, optional):  The Region in which to create the meeting. Default: us-east-1.   Available values: af-south-1 , ap-northeast-1 , ap-northeast-2 , ap-south-1 , ap-southeast-1 , ap-southeast-2 , ca-central-1 , eu-central-1 , eu-north-1 , eu-south-1 , eu-west-1 , eu-west-2 , eu-west-3 , sa-east-1 , us-east-1 , us-east-2 , us-west-1 , us-west-2 . . Defaults to None.
        tags(List, optional): The tag key-value pairs. Defaults to None.
        notifications_configuration(Dict, optional): The configuration for resource targets to receive notifications when meeting and attendee events occur. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.init.create(ctx, client_request_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.init.create client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_meeting",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "ExternalMeetingId": external_meeting_id,
            "MeetingHostId": meeting_host_id,
            "MediaRegion": media_region,
            "Tags": tags,
            "NotificationsConfiguration": notifications_configuration,
        },
    )


async def delete(hub, ctx, meeting_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.init.delete(ctx, meeting_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.init.delete meeting_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_meeting",
        op_kwargs={"MeetingId": meeting_id},
    )


async def get(hub, ctx, meeting_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide .

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.init.get(ctx, meeting_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.init.get meeting_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_meeting",
        op_kwargs={"MeetingId": meeting_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

     Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

    Args:
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_meetings",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def tag(hub, ctx, meeting_id: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Applies the specified tags to the specified Amazon Chime SDK meeting.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        tags(List): The tag key-value pairs.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.init.tag(ctx, meeting_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.init.tag meeting_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="tag_meeting",
        op_kwargs={"MeetingId": meeting_id, "Tags": tags},
    )


async def untag(hub, ctx, meeting_id: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Untags the specified tags from the specified Amazon Chime SDK meeting.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        tag_keys(List): The tag keys.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.init.untag(ctx, meeting_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.init.untag meeting_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="untag_meeting",
        op_kwargs={"MeetingId": meeting_id, "TagKeys": tag_keys},
    )
