"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    meeting_id: str,
    from_phone_number: str,
    to_phone_number: str,
    join_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer. To play welcome audio or implement an interactive voice response (IVR), use the CreateSipMediaApplicationCall action with the corresponding SIP media application ID.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        from_phone_number(str): Phone number used as the caller ID when the remote party receives a call.
        to_phone_number(str): Phone number called when inviting someone to a meeting.
        join_token(str): Token used by the Amazon Chime SDK attendee. Call the CreateAttendee action to get a join token.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.meeting.dial_out.create(
                ctx,
                meeting_id=value,
                from_phone_number=value,
                to_phone_number=value,
                join_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.meeting.dial_out.create meeting_id=value, from_phone_number=value, to_phone_number=value, join_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_meeting_dial_out",
        op_kwargs={
            "MeetingId": meeting_id,
            "FromPhoneNumber": from_phone_number,
            "ToPhoneNumber": to_phone_number,
            "JoinToken": join_token,
        },
    )
