"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    source_type: str,
    source_arn: str,
    sink_type: str,
    sink_arn: str,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a media capture pipeline.

    Args:
        source_type(str): Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.
        source_arn(str): ARN of the source from which the media artifacts are captured.
        sink_type(str): Destination type to which the media artifacts are saved. You must use an S3 bucket. .
        sink_arn(str): The ARN of the sink type.
        client_request_token(str, optional): The token assigned to the client making the pipeline request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.media_capture_pipeline.create(
                ctx, source_type=value, source_arn=value, sink_type=value, sink_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.media_capture_pipeline.create source_type=value, source_arn=value, sink_type=value, sink_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_media_capture_pipeline",
        op_kwargs={
            "SourceType": source_type,
            "SourceArn": source_arn,
            "SinkType": sink_type,
            "SinkArn": sink_arn,
            "ClientRequestToken": client_request_token,
        },
    )


async def delete(hub, ctx, media_pipeline_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the media capture pipeline.

    Args:
        media_pipeline_id(str): The ID of the media capture pipeline being deleted. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.media_capture_pipeline.delete(
                ctx, media_pipeline_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.media_capture_pipeline.delete media_pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_media_capture_pipeline",
        op_kwargs={"MediaPipelineId": media_pipeline_id},
    )


async def get(hub, ctx, media_pipeline_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an existing media capture pipeline.

    Args:
        media_pipeline_id(str): The ID of the pipeline that you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.media_capture_pipeline.get(ctx, media_pipeline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.media_capture_pipeline.get media_pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_media_capture_pipeline",
        op_kwargs={"MediaPipelineId": media_pipeline_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of media capture pipelines.

    Args:
        next_token(str, optional): The token used to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Valid Range: 1 - 99. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.media_capture_pipeline.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.media_capture_pipeline.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_media_capture_pipelines",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
