"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.global_setting.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.global_setting.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="chime", operation="get_global_settings", op_kwargs={}
    )


async def update_multiple(
    hub, ctx, business_calling: Dict, voice_connector: Dict
) -> None:
    r"""
    **Autogenerated function**

    Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.

    Args:
        business_calling(Dict): The Amazon Chime Business Calling settings.
        voice_connector(Dict): The Amazon Chime Voice Connector settings.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.global_setting.update_multiple(
                ctx, business_calling=value, voice_connector=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.global_setting.update_multiple business_calling=value, voice_connector=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_global_settings",
        op_kwargs={
            "BusinessCalling": business_calling,
            "VoiceConnector": voice_connector,
        },
    )
