"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, phone_number_ids: List) -> Dict:
    r"""
    **Autogenerated function**

     Moves phone numbers into the Deletion queue. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.   Phone numbers remain in the Deletion queue for 7 days before they are deleted permanently.

    Args:
        phone_number_ids(List): List of phone number IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.delete_phone_number.batch(ctx, phone_number_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.delete_phone_number.batch phone_number_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_delete_phone_number",
        op_kwargs={"PhoneNumberIds": phone_number_ids},
    )
