"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, account_id: str, room_id: str, membership_item_list: List
) -> Dict:
    r"""
    **Autogenerated function**

    Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.

    Args:
        account_id(str): The Amazon Chime account ID.
        room_id(str): The room ID.
        membership_item_list(List): The list of membership items.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.create.room_membership.batch(
                ctx, account_id=value, room_id=value, membership_item_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.create.room_membership.batch account_id=value, room_id=value, membership_item_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_create_room_membership",
        op_kwargs={
            "AccountId": account_id,
            "RoomId": room_id,
            "MembershipItemList": membership_item_list,
        },
    )
