"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    channel_arn: str,
    member_arns: List,
    type_: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a specified number of users to a channel.

    Args:
        channel_arn(str): The ARN of the channel to which you're adding users.
        type_(str, optional): The membership type of a user, DEFAULT or HIDDEN. Default members are always returned as part of ListChannelMemberships. Hidden members are only returned if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden members are not returned. This is only supported by moderators. Defaults to None.
        member_arns(List): The ARNs of the members you want to add to the channel.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.create.channel_membership.batch(
                ctx, channel_arn=value, member_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.create.channel_membership.batch channel_arn=value, member_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_create_channel_membership",
        op_kwargs={
            "ChannelArn": channel_arn,
            "Type": type_,
            "MemberArns": member_arns,
            "ChimeBearer": chime_bearer,
        },
    )
