"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, meeting_id: str, attendees: List) -> Dict:
    r"""
    **Autogenerated function**

     Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        attendees(List): The request containing the attendees to create.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.create.attendee.batch(
                ctx, meeting_id=value, attendees=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.create.attendee.batch meeting_id=value, attendees=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="batch_create_attendee",
        op_kwargs={"MeetingId": meeting_id, "Attendees": attendees},
    )
