"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, channel_arn: str, chime_bearer: str = None) -> Dict:
    r"""
    **Autogenerated function**

    The details of the time when a user last read messages in a channel.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.read_marker.update(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.read_marker.update channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_channel_read_marker",
        op_kwargs={"ChannelArn": channel_arn, "ChimeBearer": chime_bearer},
    )
