"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, channel_arn: str, channel_moderator_arn: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new ChannelModerator. A channel moderator can:   Add and remove other members of the channel.   Add and remove other moderators of the channel.   Add and remove user bans for the channel.   Redact messages in the channel.   List messages in the channel.    The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        channel_moderator_arn(str): The ARN of the moderator.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.moderator.create(
                ctx, channel_arn=value, channel_moderator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.moderator.create channel_arn=value, channel_moderator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_channel_moderator",
        op_kwargs={
            "ChannelArn": channel_arn,
            "ChannelModeratorArn": channel_moderator_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def delete(
    hub, ctx, channel_arn: str, channel_moderator_arn: str, chime_bearer: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes a channel moderator.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        channel_moderator_arn(str): The ARN of the moderator being deleted.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.moderator.delete(
                ctx, channel_arn=value, channel_moderator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.moderator.delete channel_arn=value, channel_moderator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_channel_moderator",
        op_kwargs={
            "ChannelArn": channel_arn,
            "ChannelModeratorArn": channel_moderator_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def describe(
    hub, ctx, channel_arn: str, channel_moderator_arn: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the full details of a single ChannelModerator.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        channel_moderator_arn(str): The ARN of the channel moderator.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.moderator.describe(
                ctx, channel_arn=value, channel_moderator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.moderator.describe channel_arn=value, channel_moderator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_channel_moderator",
        op_kwargs={
            "ChannelArn": channel_arn,
            "ChannelModeratorArn": channel_moderator_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def list_all(
    hub,
    ctx,
    channel_arn: str,
    max_results: int = None,
    next_token: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the moderators for a channel.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        max_results(int, optional): The maximum number of moderators that you want returned. Defaults to None.
        next_token(str, optional): The token passed by previous API calls until all requested moderators are returned. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.moderator.list_all(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.moderator.list_all channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_channel_moderators",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChimeBearer": chime_bearer,
        },
    )
