"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub, ctx, channel_arn: str, message_id: str, chime_bearer: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by UpdateChannelMessage.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        message_id(str): The ID of the message being deleted.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.message.delete(
                ctx, channel_arn=value, message_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.message.delete channel_arn=value, message_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_channel_message",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MessageId": message_id,
            "ChimeBearer": chime_bearer,
        },
    )


async def get(
    hub, ctx, channel_arn: str, message_id: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the full details of a channel message.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        message_id(str): The ID of the message.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.message.get(
                ctx, channel_arn=value, message_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.message.get channel_arn=value, message_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_channel_message",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MessageId": message_id,
            "ChimeBearer": chime_bearer,
        },
    )


async def list_all(
    hub,
    ctx,
    channel_arn: str,
    sort_order: str = None,
    not_before: str = None,
    not_after: str = None,
    max_results: int = None,
    next_token: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List all the messages in a channel. Returns a paginated list of ChannelMessages. By default, sorted by creation timestamp in descending order.  Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message. Also, the x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        sort_order(str, optional): The order in which you want messages sorted. Default is Descending, based on time created. Defaults to None.
        not_before(str, optional): The initial or starting time stamp for your requested messages. Defaults to None.
        not_after(str, optional): The final or ending time stamp for your requested messages. Defaults to None.
        max_results(int, optional): The maximum number of messages that you want returned. Defaults to None.
        next_token(str, optional): The token passed by previous API calls until all requested messages are returned. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.message.list_all(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.message.list_all channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_channel_messages",
        op_kwargs={
            "ChannelArn": channel_arn,
            "SortOrder": sort_order,
            "NotBefore": not_before,
            "NotAfter": not_after,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChimeBearer": chime_bearer,
        },
    )


async def redact(
    hub, ctx, channel_arn: str, message_id: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel containing the messages that you want to redact.
        message_id(str): The ID of the message being redacted.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.message.redact(
                ctx, channel_arn=value, message_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.message.redact channel_arn=value, message_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="redact_channel_message",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MessageId": message_id,
            "ChimeBearer": chime_bearer,
        },
    )


async def send(
    hub,
    ctx,
    channel_arn: str,
    content: str,
    type_: str,
    persistence: str,
    client_request_token: str,
    metadata: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends a message to a particular channel that the member is a part of.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header. Also, STANDARD messages can contain 4KB of data and the 1KB of metadata. CONTROL messages can contain 30 bytes of data and no metadata.

    Args:
        channel_arn(str): The ARN of the channel.
        content(str): The content of the message.
        type_(str): The type of message, STANDARD or CONTROL.
        persistence(str): Boolean that controls whether the message is persisted on the back end. Required.
        metadata(str, optional): The optional metadata for each message. Defaults to None.
        client_request_token(str): The Idempotency token for each client request.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.message.send(
                ctx,
                channel_arn=value,
                content=value,
                type_=value,
                persistence=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.message.send channel_arn=value, content=value, type_=value, persistence=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="send_channel_message",
        op_kwargs={
            "ChannelArn": channel_arn,
            "Content": content,
            "Type": type_,
            "Persistence": persistence,
            "Metadata": metadata,
            "ClientRequestToken": client_request_token,
            "ChimeBearer": chime_bearer,
        },
    )


async def update(
    hub,
    ctx,
    channel_arn: str,
    message_id: str,
    content: str = None,
    metadata: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the content of a message.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        message_id(str): The ID string of the message being updated.
        content(str, optional): The content of the message being updated. Defaults to None.
        metadata(str, optional): The metadata of the message being updated. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.message.update(
                ctx, channel_arn=value, message_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.message.update channel_arn=value, message_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_channel_message",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MessageId": message_id,
            "Content": content,
            "Metadata": metadata,
            "ChimeBearer": chime_bearer,
        },
    )
