"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, channel_arn: str, member_arn: str, type_: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a user to a channel. The InvitedBy response field is derived from the request header. A channel member can:   List messages   Send messages   Receive messages   Edit their own messages   Leave the channel   Privacy settings impact this action as follows:   Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.   Private Channels: You must be a member to list or send messages.    The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel to which you're adding users.
        member_arn(str): The ARN of the member you want to add to the channel.
        type_(str): The membership type of a user, DEFAULT or HIDDEN. Default members are always returned as part of ListChannelMemberships. Hidden members are only returned if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden members are not returned. This is only supported by moderators.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.membership.init.create(
                ctx, channel_arn=value, member_arn=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.membership.init.create channel_arn=value, member_arn=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_channel_membership",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MemberArn": member_arn,
            "Type": type_,
            "ChimeBearer": chime_bearer,
        },
    )


async def delete(
    hub, ctx, channel_arn: str, member_arn: str, chime_bearer: str = None
) -> None:
    r"""
    **Autogenerated function**

    Removes a member from a channel.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel from which you want to remove the user.
        member_arn(str): The ARN of the member that you're removing from the channel.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.membership.init.delete(
                ctx, channel_arn=value, member_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.membership.init.delete channel_arn=value, member_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_channel_membership",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MemberArn": member_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def describe(
    hub, ctx, channel_arn: str, member_arn: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the full details of a user's channel membership.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        member_arn(str): The ARN of the member.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.membership.init.describe(
                ctx, channel_arn=value, member_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.membership.init.describe channel_arn=value, member_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_channel_membership",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MemberArn": member_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def list_all(
    hub,
    ctx,
    channel_arn: str,
    type_: str = None,
    max_results: int = None,
    next_token: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all channel memberships in a channel.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The maximum number of channel memberships that you want returned.
        type_(str, optional): The membership type of a user, DEFAULT or HIDDEN. Default members are always returned as part of ListChannelMemberships. Hidden members are only returned if the type filter in ListChannelMemberships equals HIDDEN. Otherwise hidden members are not returned. Defaults to None.
        max_results(int, optional): The maximum number of channel memberships that you want returned. Defaults to None.
        next_token(str, optional): The token passed by previous API calls until all requested channel memberships are returned. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.membership.init.list_all(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.membership.init.list_all channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_channel_memberships",
        op_kwargs={
            "ChannelArn": channel_arn,
            "Type": type_,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChimeBearer": chime_bearer,
        },
    )
