"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def describe(
    hub, ctx, channel_arn: str, app_instance_user_arn: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the details of a channel based on the membership of the specified AppInstanceUser.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel to which the user belongs.
        app_instance_user_arn(str): The ARN of the user in a channel.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.membership.for_app_instance_user.describe(
                ctx, channel_arn=value, app_instance_user_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.membership.for_app_instance_user.describe channel_arn=value, app_instance_user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_channel_membership_for_app_instance_user",
        op_kwargs={
            "ChannelArn": channel_arn,
            "AppInstanceUserArn": app_instance_user_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def list_(
    hub,
    ctx,
    app_instance_user_arn: str = None,
    max_results: int = None,
    next_token: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists all channels that a particular AppInstanceUser is a part of. Only an AppInstanceAdmin can call the API with a user ARN that is not their own.   The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        app_instance_user_arn(str, optional): The ARN of the AppInstanceUsers. Defaults to None.
        max_results(int, optional): The maximum number of users that you want returned. Defaults to None.
        next_token(str, optional): The token returned from previous API requests until the number of channel memberships is reached. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.membership.for_app_instance_user.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.membership.for_app_instance_user.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_channel_memberships_for_app_instance_user",
        op_kwargs={
            "AppInstanceUserArn": app_instance_user_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChimeBearer": chime_bearer,
        },
    )
