"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    app_instance_arn: str,
    name: str,
    client_request_token: str,
    mode: str = None,
    privacy: str = None,
    metadata: str = None,
    tags: List = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a channel to which you can add users and send messages.  Restriction: You can't change a channel's privacy.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        app_instance_arn(str): The ARN of the channel request.
        name(str): The name of the channel.
        mode(str, optional): The channel mode: UNRESTRICTED or RESTRICTED. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels. Defaults to None.
        privacy(str, optional): The channel's privacy level: PUBLIC or PRIVATE. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the AppInstance. Defaults to None.
        metadata(str, optional): The metadata of the creation request. Limited to 1KB and UTF-8. Defaults to None.
        client_request_token(str): The client token for the request. An Idempotency token.
        tags(List, optional): The tags for the creation request. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.init.create(
                ctx, app_instance_arn=value, name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.init.create app_instance_arn=value, name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_channel",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "Name": name,
            "Mode": mode,
            "Privacy": privacy,
            "Metadata": metadata,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
            "ChimeBearer": chime_bearer,
        },
    )


async def delete(hub, ctx, channel_arn: str, chime_bearer: str = None) -> None:
    r"""
    **Autogenerated function**

    Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel being deleted.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.init.delete(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.init.delete channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_channel",
        op_kwargs={"ChannelArn": channel_arn, "ChimeBearer": chime_bearer},
    )


async def describe(hub, ctx, channel_arn: str, chime_bearer: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the full details of a channel in an Amazon Chime AppInstance.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.init.describe(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.init.describe channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_channel",
        op_kwargs={"ChannelArn": channel_arn, "ChimeBearer": chime_bearer},
    )


async def list_all(
    hub,
    ctx,
    app_instance_arn: str,
    privacy: str = None,
    max_results: int = None,
    next_token: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.  Functionality & restrictions    Use privacy = PUBLIC to retrieve all public channels in the account.   Only an AppInstanceAdmin can set privacy = PRIVATE to list the private channels in an account.    The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
        privacy(str, optional): The privacy setting. PUBLIC retrieves all the public channels. PRIVATE retrieves private channels. Only an AppInstanceAdmin can retrieve private channels. . Defaults to None.
        max_results(int, optional): The maximum number of channels that you want to return. Defaults to None.
        next_token(str, optional): The token passed by previous API calls until all requested channels are returned. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.init.list_all(ctx, app_instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.init.list_all app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_channels",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "Privacy": privacy,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChimeBearer": chime_bearer,
        },
    )


async def update(
    hub,
    ctx,
    channel_arn: str,
    name: str,
    mode: str,
    metadata: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a channel's attributes.  Restriction: You can't change a channel's privacy.   The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        name(str): The name of the channel.
        mode(str): The mode of the update request.
        metadata(str, optional): The metadata for the update request. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.init.update(
                ctx, channel_arn=value, name=value, mode=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.init.update channel_arn=value, name=value, mode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_channel",
        op_kwargs={
            "ChannelArn": channel_arn,
            "Name": name,
            "Mode": mode,
            "Metadata": metadata,
            "ChimeBearer": chime_bearer,
        },
    )
