"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, channel_arn: str, member_arn: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to DeleteChannelBan, and then CreateChannelMembership. Bans are cleaned up when you delete users or channels. If you ban a user who is already part of a channel, that user is automatically kicked from the channel.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the ban request.
        member_arn(str): The ARN of the member being banned.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.ban.create(
                ctx, channel_arn=value, member_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.ban.create channel_arn=value, member_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_channel_ban",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MemberArn": member_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def delete(
    hub, ctx, channel_arn: str, member_arn: str, chime_bearer: str = None
) -> None:
    r"""
    **Autogenerated function**

    Removes a user from a channel's ban list.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel from which the AppInstanceUser was banned.
        member_arn(str): The ARN of the AppInstanceUser that you want to reinstate.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.ban.delete(
                ctx, channel_arn=value, member_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.ban.delete channel_arn=value, member_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_channel_ban",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MemberArn": member_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def describe(
    hub, ctx, channel_arn: str, member_arn: str, chime_bearer: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the full details of a channel ban.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel from which the user is banned.
        member_arn(str): The ARN of the member being banned.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.ban.describe(
                ctx, channel_arn=value, member_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.ban.describe channel_arn=value, member_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_channel_ban",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MemberArn": member_arn,
            "ChimeBearer": chime_bearer,
        },
    )


async def list_all(
    hub,
    ctx,
    channel_arn: str,
    max_results: int = None,
    next_token: str = None,
    chime_bearer: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the users banned from a particular channel.  The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in the header.

    Args:
        channel_arn(str): The ARN of the channel.
        max_results(int, optional): The maximum number of bans that you want returned. Defaults to None.
        next_token(str, optional): The token passed by previous API calls until all requested bans are returned. Defaults to None.
        chime_bearer(str, optional): The AppInstanceUserArn of the user that makes the API call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.channel.ban.list_all(ctx, channel_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.channel.ban.list_all channel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_channel_bans",
        op_kwargs={
            "ChannelArn": channel_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ChimeBearer": chime_bearer,
        },
    )
