"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, account_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.

    Args:
        account_id(str): The Amazon Chime account ID.
        max_results(int, optional): The maximum number of results to return in a single call. The default is 10. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.bots.list(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.bots.list account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_bots",
        op_kwargs={
            "AccountId": account_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
