"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, account_id: str, display_name: str, domain: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a bot for an Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        display_name(str): The bot display name.
        domain(str, optional): The domain of the Amazon Chime Enterprise account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.bot.create(ctx, account_id=value, display_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.bot.create account_id=value, display_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_bot",
        op_kwargs={
            "AccountId": account_id,
            "DisplayName": display_name,
            "Domain": domain,
        },
    )


async def get(hub, ctx, account_id: str, bot_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.

    Args:
        account_id(str): The Amazon Chime account ID.
        bot_id(str): The bot ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.bot.get(ctx, account_id=value, bot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.bot.get account_id=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_bot",
        op_kwargs={"AccountId": account_id, "BotId": bot_id},
    )


async def update(hub, ctx, account_id: str, bot_id: str, disabled: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.

    Args:
        account_id(str): The Amazon Chime account ID.
        bot_id(str): The bot ID.
        disabled(bool, optional): When true, stops the specified bot from running in your account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.bot.update(ctx, account_id=value, bot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.bot.update account_id=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_bot",
        op_kwargs={"AccountId": account_id, "BotId": bot_id, "Disabled": disabled},
    )
