"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def search(
    hub,
    ctx,
    area_code: str = None,
    city: str = None,
    country: str = None,
    state: str = None,
    toll_free_prefix: str = None,
    phone_number_type: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: AreaCode, City, State, or TollFreePrefix. If you provide City, you must also provide State. Numbers outside the US only support the PhoneNumberType filter, which you must use.

    Args:
        area_code(str, optional): The area code used to filter results. Only applies to the US. Defaults to None.
        city(str, optional): The city used to filter results. Only applies to the US. Defaults to None.
        country(str, optional): The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2. Defaults to None.
        state(str, optional): The state used to filter results. Required only if you provide City. Only applies to the US. Defaults to None.
        toll_free_prefix(str, optional): The toll-free prefix that you use to filter results. Only applies to the US. Defaults to None.
        phone_number_type(str, optional): The phone number type used to filter results. Required for non-US numbers. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): The token used to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.available_phone_number.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.available_phone_number.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="search_available_phone_numbers",
        op_kwargs={
            "AreaCode": area_code,
            "City": city,
            "Country": country,
            "State": state,
            "TollFreePrefix": toll_free_prefix,
            "PhoneNumberType": phone_number_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
