"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, meeting_id: str, external_user_id: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        external_user_id(str): The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
        tags(List, optional): The tag key-value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.attendee.init.create(
                ctx, meeting_id=value, external_user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.attendee.init.create meeting_id=value, external_user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_attendee",
        op_kwargs={
            "MeetingId": meeting_id,
            "ExternalUserId": external_user_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, meeting_id: str, attendee_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their JoinToken. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        attendee_id(str): The Amazon Chime SDK attendee ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.attendee.init.delete(
                ctx, meeting_id=value, attendee_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.attendee.init.delete meeting_id=value, attendee_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_attendee",
        op_kwargs={"MeetingId": meeting_id, "AttendeeId": attendee_id},
    )


async def get(hub, ctx, meeting_id: str, attendee_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide .

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        attendee_id(str): The Amazon Chime SDK attendee ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.attendee.init.get(
                ctx, meeting_id=value, attendee_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.attendee.init.get meeting_id=value, attendee_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_attendee",
        op_kwargs={"MeetingId": meeting_id, "AttendeeId": attendee_id},
    )


async def list_all(
    hub, ctx, meeting_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime Developer Guide.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.attendee.init.list_all(ctx, meeting_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.attendee.init.list_all meeting_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_attendees",
        op_kwargs={
            "MeetingId": meeting_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def tag(hub, ctx, meeting_id: str, attendee_id: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Applies the specified tags to the specified Amazon Chime SDK attendee.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        attendee_id(str): The Amazon Chime SDK attendee ID.
        tags(List): The tag key-value pairs.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.attendee.init.tag(
                ctx, meeting_id=value, attendee_id=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.attendee.init.tag meeting_id=value, attendee_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="tag_attendee",
        op_kwargs={"MeetingId": meeting_id, "AttendeeId": attendee_id, "Tags": tags},
    )


async def untag(hub, ctx, meeting_id: str, attendee_id: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Untags the specified tags from the specified Amazon Chime SDK attendee.

    Args:
        meeting_id(str): The Amazon Chime SDK meeting ID.
        attendee_id(str): The Amazon Chime SDK attendee ID.
        tag_keys(List): The tag keys.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.attendee.init.untag(
                ctx, meeting_id=value, attendee_id=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.attendee.init.untag meeting_id=value, attendee_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="untag_attendee",
        op_kwargs={
            "MeetingId": meeting_id,
            "AttendeeId": attendee_id,
            "TagKeys": tag_keys,
        },
    )
