"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    app_instance_arn: str,
    app_instance_user_id: str,
    name: str,
    client_request_token: str,
    metadata: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user under an Amazon Chime AppInstance. The request consists of a unique appInstanceUserId and Name for that user.

    Args:
        app_instance_arn(str): The ARN of the AppInstance request.
        app_instance_user_id(str): The user ID of the AppInstance.
        name(str): The user's name.
        metadata(str, optional): The request's metadata. Limited to a 1KB string in UTF-8. Defaults to None.
        client_request_token(str): The token assigned to the user requesting an AppInstance.
        tags(List, optional): Tags assigned to the AppInstanceUser. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.user.create(
                ctx,
                app_instance_arn=value,
                app_instance_user_id=value,
                name=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.user.create app_instance_arn=value, app_instance_user_id=value, name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_app_instance_user",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "AppInstanceUserId": app_instance_user_id,
            "Name": name,
            "Metadata": metadata,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, app_instance_user_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an AppInstanceUser.

    Args:
        app_instance_user_arn(str): The ARN of the user request being deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.user.delete(ctx, app_instance_user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.user.delete app_instance_user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_app_instance_user",
        op_kwargs={"AppInstanceUserArn": app_instance_user_arn},
    )


async def describe(hub, ctx, app_instance_user_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the full details of an AppInstanceUser .

    Args:
        app_instance_user_arn(str): The ARN of the AppInstanceUser.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.user.describe(
                ctx, app_instance_user_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.user.describe app_instance_user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_app_instance_user",
        op_kwargs={"AppInstanceUserArn": app_instance_user_arn},
    )


async def list_all(
    hub, ctx, app_instance_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     List all AppInstanceUsers created under a single AppInstance.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
        max_results(int, optional): The maximum number of requests that you want returned. Defaults to None.
        next_token(str, optional): The token passed by previous API calls until all requested users are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.user.list_all(ctx, app_instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.user.list_all app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_app_instance_users",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, app_instance_user_arn: str, name: str, metadata: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of an AppInstanceUser. You can update names and metadata.

    Args:
        app_instance_user_arn(str): The ARN of the AppInstanceUser.
        name(str): The name of the AppInstanceUser.
        metadata(str, optional): The metadata of the AppInstanceUser. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.user.update(
                ctx, app_instance_user_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.user.update app_instance_user_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_app_instance_user",
        op_kwargs={
            "AppInstanceUserArn": app_instance_user_arn,
            "Name": name,
            "Metadata": metadata,
        },
    )
