"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, app_instance_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the streaming configurations of an AppInstance.

    Args:
        app_instance_arn(str): The ARN of the streaming configurations being deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.streaming_configuration.delete_multiple(
                ctx, app_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.streaming_configuration.delete_multiple app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_app_instance_streaming_configurations",
        op_kwargs={"AppInstanceArn": app_instance_arn},
    )


async def get_all(hub, ctx, app_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the streaming settings for an AppInstance.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.streaming_configuration.get_all(
                ctx, app_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.streaming_configuration.get_all app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_app_instance_streaming_configurations",
        op_kwargs={"AppInstanceArn": app_instance_arn},
    )


async def put_multiple(
    hub, ctx, app_instance_arn: str, app_instance_streaming_configurations: List
) -> Dict:
    r"""
    **Autogenerated function**

    The data streaming configurations of an AppInstance.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
        app_instance_streaming_configurations(List): The streaming configurations set for an AppInstance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.streaming_configuration.put_multiple(
                ctx, app_instance_arn=value, app_instance_streaming_configurations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.streaming_configuration.put_multiple app_instance_arn=value, app_instance_streaming_configurations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_app_instance_streaming_configurations",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "AppInstanceStreamingConfigurations": app_instance_streaming_configurations,
        },
    )
