"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, app_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the retention settings for an AppInstance.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.retention_setting.get_all(
                ctx, app_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.retention_setting.get_all app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_app_instance_retention_settings",
        op_kwargs={"AppInstanceArn": app_instance_arn},
    )


async def put_multiple(
    hub, ctx, app_instance_arn: str, app_instance_retention_settings: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the amount of time in days that a given AppInstance retains data.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
        app_instance_retention_settings(Dict): The time in days to retain data. Data type: number.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.retention_setting.put_multiple(
                ctx, app_instance_arn=value, app_instance_retention_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.retention_setting.put_multiple app_instance_arn=value, app_instance_retention_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="put_app_instance_retention_settings",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "AppInstanceRetentionSettings": app_instance_retention_settings,
        },
    )
