"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    client_request_token: str,
    metadata: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only SDK messaging customers use this API. CreateAppInstance supports idempotency behavior as described in the AWS API Standard.

    Args:
        name(str): The name of the AppInstance.
        metadata(str, optional): The metadata of the AppInstance. Limited to a 1KB string in UTF-8. Defaults to None.
        client_request_token(str): The ClientRequestToken of the AppInstance.
        tags(List, optional): Tags assigned to the AppInstanceUser. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.init.create(
                ctx, name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.init.create name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_app_instance",
        op_kwargs={
            "Name": name,
            "Metadata": metadata,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, app_instance_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an AppInstance and all associated data asynchronously.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.init.delete(ctx, app_instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.init.delete app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_app_instance",
        op_kwargs={"AppInstanceArn": app_instance_arn},
    )


async def describe(hub, ctx, app_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the full details of an AppInstance.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.init.describe(ctx, app_instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.init.describe app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_app_instance",
        op_kwargs={"AppInstanceArn": app_instance_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all Amazon Chime AppInstances created under a single AWS account.

    Args:
        max_results(int, optional): The maximum number of AppInstances that you want to return. Defaults to None.
        next_token(str, optional): The token passed by previous API requests until you reach the maximum number of AppInstances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_app_instances",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, app_instance_arn: str, name: str, metadata: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates AppInstance metadata.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
        name(str): The name that you want to change.
        metadata(str, optional): The metadata that you want to change. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.init.update(
                ctx, app_instance_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.init.update app_instance_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_app_instance",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "Name": name,
            "Metadata": metadata,
        },
    )
