"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, app_instance_admin_arn: str, app_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Promotes an AppInstanceUser to an AppInstanceAdmin. The promoted user can perform the following actions.     ChannelModerator actions across all channels in the AppInstance.    DeleteChannelMessage actions.   Only an AppInstanceUser can be promoted to an AppInstanceAdmin role.

    Args:
        app_instance_admin_arn(str): The ARN of the administrator of the current AppInstance.
        app_instance_arn(str): The ARN of the AppInstance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.admin.create(
                ctx, app_instance_admin_arn=value, app_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.admin.create app_instance_admin_arn=value, app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="create_app_instance_admin",
        op_kwargs={
            "AppInstanceAdminArn": app_instance_admin_arn,
            "AppInstanceArn": app_instance_arn,
        },
    )


async def delete(hub, ctx, app_instance_admin_arn: str, app_instance_arn: str) -> None:
    r"""
    **Autogenerated function**

    Demotes an AppInstanceAdmin to an AppInstanceUser. This action does not delete the user.

    Args:
        app_instance_admin_arn(str): The ARN of the AppInstance's administrator.
        app_instance_arn(str): The ARN of the AppInstance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.admin.delete(
                ctx, app_instance_admin_arn=value, app_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.admin.delete app_instance_admin_arn=value, app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_app_instance_admin",
        op_kwargs={
            "AppInstanceAdminArn": app_instance_admin_arn,
            "AppInstanceArn": app_instance_arn,
        },
    )


async def describe(
    hub, ctx, app_instance_admin_arn: str, app_instance_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the full details of an AppInstanceAdmin.

    Args:
        app_instance_admin_arn(str): The ARN of the AppInstanceAdmin.
        app_instance_arn(str): The ARN of the AppInstance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.admin.describe(
                ctx, app_instance_admin_arn=value, app_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.admin.describe app_instance_admin_arn=value, app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="describe_app_instance_admin",
        op_kwargs={
            "AppInstanceAdminArn": app_instance_admin_arn,
            "AppInstanceArn": app_instance_arn,
        },
    )


async def list_all(
    hub, ctx, app_instance_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the administrators in the AppInstance.

    Args:
        app_instance_arn(str): The ARN of the AppInstance.
        max_results(int, optional): The maximum number of administrators that you want to return. Defaults to None.
        next_token(str, optional): The token returned from previous API requests until the number of administrators is reached. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.app_instance.admin.list_all(ctx, app_instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.app_instance.admin.list_all app_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_app_instance_admins",
        op_kwargs={
            "AppInstanceArn": app_instance_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
