"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see Use the Policies Page in the Amazon Chime Administration Guide.

    Args:
        account_id(str): The Amazon Chime account ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.setting.get_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.setting.get_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_account_settings",
        op_kwargs={"AccountId": account_id},
    )


async def update_multiple(hub, ctx, account_id: str, account_settings: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see Use the Policies Page in the Amazon Chime Administration Guide.

    Args:
        account_id(str): The Amazon Chime account ID.
        account_settings(Dict): The Amazon Chime account settings to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.setting.update_multiple(
                ctx, account_id=value, account_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.setting.update_multiple account_id=value, account_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_account_settings",
        op_kwargs={"AccountId": account_id, "AccountSettings": account_settings},
    )
