"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Chime account under the administrator's AWS account. Only Team account types are currently supported for this action. For more information about different account types, see Managing Your Amazon Chime Accounts in the Amazon Chime Administration Guide.

    Args:
        name(str): The name of the Amazon Chime account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="chime", operation="create_account", op_kwargs={"Name": name}
    )


async def delete(hub, ctx, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Amazon Chime account. You must suspend all users before deleting Team account. You can use the BatchSuspendUser action to dodo. For EnterpriseLWA and EnterpriseAD accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended. Deleted accounts appear in your Disabled accounts list for 90 days. To restore deleted account from your Disabled accounts list, you must contact AWS Support. After 90 days, deleted accounts are permanently removed from your Disabled accounts list.

    Args:
        account_id(str): The Amazon Chime account ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.init.delete(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.init.delete account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="delete_account",
        op_kwargs={"AccountId": account_id},
    )


async def get(hub, ctx, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.

    Args:
        account_id(str): The Amazon Chime account ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.init.get(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.init.get account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="get_account",
        op_kwargs={"AccountId": account_id},
    )


async def list_all(
    hub,
    ctx,
    name: str = None,
    user_email: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.

    Args:
        name(str, optional): Amazon Chime account name prefix with which to filter results. Defaults to None.
        user_email(str, optional): User email address with which to filter results. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="list_accounts",
        op_kwargs={
            "Name": name,
            "UserEmail": user_email,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, account_id: str, name: str = None, default_license: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.

    Args:
        account_id(str): The Amazon Chime account ID.
        name(str, optional): The new name for the specified Amazon Chime account. Defaults to None.
        default_license(str, optional): The default license applied when you add users to an Amazon Chime account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.chime.account.init.update(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.chime.account.init.update account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="chime",
        operation="update_account",
        op_kwargs={
            "AccountId": account_id,
            "Name": name,
            "DefaultLicense": default_license,
        },
    )
