"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    time_period: Dict,
    granularity: str = None,
    filter_: Dict = None,
    sort_by: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use GetDimensionValues in SAVINGS_PLANS to determine the possible dimension values.  You cannot group by any dimension values for GetSavingsPlansUtilization.

    Args:
        time_period(Dict): The time period that you want the usage and costs for. The Start date must be within 13 months. The End date must be after the Start date, and before the current date. Future dates can't be used as an End date.
        granularity(str, optional): The granularity of the Amazon Web Services utillization data for your Savings Plans. The GetSavingsPlansUtilization operation supports only DAILY and MONTHLY granularities. Defaults to None.
        filter_(Dict, optional): Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:    LINKED_ACCOUNT     SAVINGS_PLAN_ARN     SAVINGS_PLANS_TYPE     REGION     PAYMENT_OPTION     INSTANCE_TYPE_FAMILY     GetSavingsPlansUtilization uses the same Expression object as the other operations, but only AND is supported among each dimension. Defaults to None.
        sort_by(Dict, optional): The value by which you want to sort the data. The following values are supported for Key:    UtilizationPercentage     TotalCommitment     UsedCommitment     UnusedCommitment     NetSavings    Supported values for SortOrder are ASCENDING or DESCENDING. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.saving_plan.utilization.init.get(ctx, time_period=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.saving_plan.utilization.init.get time_period=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_savings_plans_utilization",
        op_kwargs={
            "TimePeriod": time_period,
            "Granularity": granularity,
            "Filter": filter_,
            "SortBy": sort_by,
        },
    )
