"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    time_period: Dict,
    filter_: Dict = None,
    data_type: List = None,
    next_token: str = None,
    max_results: int = None,
    sort_by: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to GetSavingsPlanUtilization, but you have the option to make multiple calls to GetSavingsPlanUtilizationDetails by providing individual dates. You can use GetDimensionValues in SAVINGS_PLANS to determine the possible dimension values.   GetSavingsPlanUtilizationDetails internally groups data by SavingsPlansArn.

    Args:
        time_period(Dict): The time period that you want the usage and costs for. The Start date must be within 13 months. The End date must be after the Start date, and before the current date. Future dates can't be used as an End date.
        filter_(Dict, optional): Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:    LINKED_ACCOUNT     SAVINGS_PLAN_ARN     REGION     PAYMENT_OPTION     INSTANCE_TYPE_FAMILY     GetSavingsPlansUtilizationDetails uses the same Expression object as the other operations, but only AND is supported among each dimension. Defaults to None.
        data_type(List, optional): The data type. Defaults to None.
        next_token(str, optional): The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. Defaults to None.
        max_results(int, optional): The number of items to be returned in a response. The default is 20, with a minimum value of 1. Defaults to None.
        sort_by(Dict, optional): The value by which you want to sort the data. The following values are supported for Key:    UtilizationPercentage     TotalCommitment     UsedCommitment     UnusedCommitment     NetSavings     AmortizedRecurringCommitment     AmortizedUpfrontCommitment    Supported values for SortOrder are ASCENDING or DESCENDING. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.saving_plan.utilization.detail.get_all(
                ctx, time_period=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.saving_plan.utilization.detail.get_all time_period=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_savings_plans_utilization_details",
        op_kwargs={
            "TimePeriod": time_period,
            "Filter": filter_,
            "DataType": data_type,
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortBy": sort_by,
        },
    )
