"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    savings_plans_type: str,
    term_in_years: str,
    payment_option: str,
    lookback_period_in_days: str,
    account_scope: str = None,
    next_page_token: str = None,
    page_size: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves your request parameters, Savings Plan Recommendations Summary and Details.

    Args:
        savings_plans_type(str): The Savings Plans recommendation type requested.
        term_in_years(str): The savings plan recommendation term used to generate these recommendations.
        payment_option(str): The payment option used to generate these recommendations.
        account_scope(str, optional): The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to PAYER. If the value is LINKED, recommendations are calculated for individual member accounts only. Defaults to None.
        next_page_token(str, optional): The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. Defaults to None.
        page_size(int, optional): The number of recommendations that you want returned in a single response object. Defaults to None.
        lookback_period_in_days(str): The lookback period used to generate the recommendation.
        filter_(Dict, optional): You can filter your recommendations by Account ID with the LINKED_ACCOUNT dimension. To filter your recommendations by Account ID, specify Key as LINKED_ACCOUNT and Value as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations. For GetSavingsPlansPurchaseRecommendation, the Filter does not include CostCategories or Tags. It only includes Dimensions. With Dimensions, Key must be LINKED_ACCOUNT and Value can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. AND and OR operators are not supported. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.saving_plan.purchase_recommendation.get(
                ctx,
                savings_plans_type=value,
                term_in_years=value,
                payment_option=value,
                lookback_period_in_days=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.saving_plan.purchase_recommendation.get savings_plans_type=value, term_in_years=value, payment_option=value, lookback_period_in_days=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_savings_plans_purchase_recommendation",
        op_kwargs={
            "SavingsPlansType": savings_plans_type,
            "TermInYears": term_in_years,
            "PaymentOption": payment_option,
            "AccountScope": account_scope,
            "NextPageToken": next_page_token,
            "PageSize": page_size,
            "LookbackPeriodInDays": lookback_period_in_days,
            "Filter": filter_,
        },
    )
