"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    time_period: Dict,
    group_by: List = None,
    granularity: str = None,
    filter_: Dict = None,
    metrics: List = None,
    next_token: str = None,
    max_results: int = None,
    sort_by: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for Savings Plans usage with the following dimensions:    LINKED_ACCOUNT     REGION     SERVICE     INSTANCE_FAMILY    To determine valid values for a dimension, use the GetDimensionValues operation.

    Args:
        time_period(Dict): The time period that you want the usage and costs for. The Start date must be within 13 months. The End date must be after the Start date, and before the current date. Future dates can't be used as an End date.
        group_by(List, optional): You can group the data using the attributes INSTANCE_FAMILY, REGION, or SERVICE. Defaults to None.
        granularity(str, optional): The granularity of the Amazon Web Services cost data for your Savings Plans. Granularity can't be set if GroupBy is set. The GetSavingsPlansCoverage operation supports only DAILY and MONTHLY granularities. Defaults to None.
        filter_(Dict, optional): Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:    LINKED_ACCOUNT     REGION     SERVICE     INSTANCE_FAMILY     GetSavingsPlansCoverage uses the same Expression object as the other operations, but only AND is supported among each dimension. If there are multiple values for a dimension, they are OR'd together. Cost category is also supported. Defaults to None.
        metrics(List, optional): The measurement that you want your Savings Plans coverage reported in. The only valid value is SpendCoveredBySavingsPlans. Defaults to None.
        next_token(str, optional): The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. Defaults to None.
        max_results(int, optional): The number of items to be returned in a response. The default is 20, with a minimum value of 1. Defaults to None.
        sort_by(Dict, optional): The value by which you want to sort the data. The following values are supported for Key:    SpendCoveredBySavingsPlan     OnDemandCost     CoveragePercentage     TotalCost     InstanceFamily     Region     Service    Supported values for SortOrder are ASCENDING or DESCENDING. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.saving_plan.coverage.get(ctx, time_period=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.saving_plan.coverage.get time_period=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_savings_plans_coverage",
        op_kwargs={
            "TimePeriod": time_period,
            "GroupBy": group_by,
            "Granularity": granularity,
            "Filter": filter_,
            "Metrics": metrics,
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortBy": sort_by,
        },
    )
