"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    service: str,
    account_id: str = None,
    filter_: Dict = None,
    account_scope: str = None,
    lookback_period_in_days: str = None,
    term_in_years: str = None,
    payment_option: str = None,
    service_specification: Dict = None,
    page_size: int = None,
    next_page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets recommendations for which reservations to purchase. These recommendations could help you reduce your costs. Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing. AWS generates your recommendations by identifying your On-Demand usage during a specific time period and collecting your usage into categories that are eligible for a reservation. After AWS has these categories, it simulates every combination of reservations in each category of usage to identify the best number of each type of RI to purchase to maximize your estimated savings.  For example, AWS automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to the c4 family usage. AWS recommends the smallest size instance in an instance family. This makes it easier to purchase a size-flexible RI. AWS also shows the equal number of normalized units so that you can purchase any instance size that you want. For this example, your RI recommendation would be for c4.large because that is the smallest size instance in the c4 instance family.

    Args:
        account_id(str, optional): The account ID that is associated with the recommendation. . Defaults to None.
        service(str): The specific service that you want recommendations for.
        filter_(Dict, optional): Use Expression to filter by cost or by usage. There are two patterns:    Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for REGION==us-east-1 OR REGION==us-west-1. For GetRightsizingRecommendation, the Region is a full name (for example, REGION==US East (N. Virginia). The Expression example looks like:  { "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }  The list of dimension values are OR'd together to retrieve cost or usage data. You can create Expression and DimensionValues objects using either with* methods or set* methods in multiple lines.    Compound dimension values with logical operations - You can use multiple Expression types and the logical operators AND/OR/NOT to create a list of one or more Expression objects. This allows you to filter on more advanced options. For example, you can filter on ((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer). The Expression for that looks like this:  { "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] }    Because each Expression can have only one operator, the service returns an error if more than one is specified. The following example shows an Expression object that creates an error.    { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } }      For the GetRightsizingRecommendation action, a combination of OR and NOT is not supported. OR is not supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE. For the GetReservationPurchaseRecommendation action, only NOT is supported. AND and OR are not supported. Dimensions are limited to LINKED_ACCOUNT. . Defaults to None.
        account_scope(str, optional): The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to PAYER. If the value is LINKED, recommendations are calculated for individual member accounts only. Defaults to None.
        lookback_period_in_days(str, optional): The number of previous days that you want AWS to consider when it calculates your recommendations. Defaults to None.
        term_in_years(str, optional): The reservation term that you want recommendations for. Defaults to None.
        payment_option(str, optional): The reservation purchase option that you want recommendations for. Defaults to None.
        service_specification(Dict, optional): The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances. Defaults to None.
        page_size(int, optional): The number of recommendations that you want returned in a single response object. Defaults to None.
        next_page_token(str, optional): The pagination token that indicates the next set of results that you want to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.reservation.purchase_recommendation.get(ctx, service=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.reservation.purchase_recommendation.get service=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_reservation_purchase_recommendation",
        op_kwargs={
            "AccountId": account_id,
            "Service": service,
            "Filter": filter_,
            "AccountScope": account_scope,
            "LookbackPeriodInDays": lookback_period_in_days,
            "TermInYears": term_in_years,
            "PaymentOption": payment_option,
            "ServiceSpecification": service_specification,
            "PageSize": page_size,
            "NextPageToken": next_page_token,
        },
    )
