"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    time_period: Dict,
    metric: str,
    granularity: str,
    filter_: Dict = None,
    prediction_interval_level: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs.

    Args:
        time_period(Dict): The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.
        metric(str): Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see Why does the "blended" annotation appear on some line items in my bill?.  Valid values for a GetCostForecast call are the following:   AMORTIZED_COST   BLENDED_COST   NET_AMORTIZED_COST   NET_UNBLENDED_COST   UNBLENDED_COST  .
        granularity(str): How granular you want the forecast to be. You can get 3 months of DAILY forecasts or 12 months of MONTHLY forecasts. The GetCostForecast operation supports only DAILY and MONTHLY granularities.
        filter_(Dict, optional): The filters that you want to use to filter your forecast. The GetCostForecast API supports filtering by the following dimensions:    AZ     INSTANCE_TYPE     LINKED_ACCOUNT     LINKED_ACCOUNT_NAME     OPERATION     PURCHASE_TYPE     REGION     SERVICE     USAGE_TYPE     USAGE_TYPE_GROUP     RECORD_TYPE     OPERATING_SYSTEM     TENANCY     SCOPE     PLATFORM     SUBSCRIPTION_ID     LEGAL_ENTITY_NAME     DEPLOYMENT_OPTION     DATABASE_ENGINE     INSTANCE_TYPE_FAMILY     BILLING_ENTITY     RESERVATION_ID     SAVINGS_PLAN_ARN   . Defaults to None.
        prediction_interval_level(int, optional): Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.cost.forecast.get(
                ctx, time_period=value, metric=value, granularity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.cost.forecast.get time_period=value, metric=value, granularity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_cost_forecast",
        op_kwargs={
            "TimePeriod": time_period,
            "Metric": metric,
            "Granularity": granularity,
            "Filter": filter_,
            "PredictionIntervalLevel": prediction_interval_level,
        },
    )
