"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, rule_version: str, rules: List, default_value: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Cost Category with the requested name and rules.

    Args:
        name(str): The unique name of the Cost Category.
        rule_version(str): The rule schema version in this particular Cost Category.
        rules(List): The Cost Category rules used to categorize costs. For more information, see CostCategoryRule.
        default_value(str, optional): The default value for the cost category. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.cost.category.definition.create(
                ctx, name=value, rule_version=value, rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.cost.category.definition.create name=value, rule_version=value, rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="create_cost_category_definition",
        op_kwargs={
            "Name": name,
            "RuleVersion": rule_version,
            "Rules": rules,
            "DefaultValue": default_value,
        },
    )


async def delete(hub, ctx, cost_category_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost Category.

    Args:
        cost_category_arn(str):  The unique identifier for your Cost Category. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.cost.category.definition.delete(ctx, cost_category_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.cost.category.definition.delete cost_category_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="delete_cost_category_definition",
        op_kwargs={"CostCategoryArn": cost_category_arn},
    )


async def describe(hub, ctx, cost_category_arn: str, effective_on: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the name, ARN, rules, definition, and effective dates of a Cost Category that's defined in the account. You have the option to use EffectiveOn to return a Cost Category that is active on a specific date. If there is no EffectiveOn specified, you’ll see a Cost Category that is effective on the current date. If Cost Category is still effective, EffectiveEnd is omitted in the response.

    Args:
        cost_category_arn(str):  The unique identifier for your Cost Category. .
        effective_on(str, optional):  The date when the Cost Category was effective. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.cost.category.definition.describe(
                ctx, cost_category_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.cost.category.definition.describe cost_category_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="describe_cost_category_definition",
        op_kwargs={"CostCategoryArn": cost_category_arn, "EffectiveOn": effective_on},
    )


async def list_all(
    hub, ctx, effective_on: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the name, ARN, NumberOfRules and effective dates of all Cost Categories defined in the account. You have the option to use EffectiveOn to return a list of Cost Categories that were active on a specific date. If there is no EffectiveOn specified, you’ll see Cost Categories that are effective on the current date. If Cost Category is still effective, EffectiveEnd is omitted in the response. ListCostCategoryDefinitions supports pagination. The request can have a MaxResults range up to 100.

    Args:
        effective_on(str, optional):  The date when the Cost Category was effective. . Defaults to None.
        next_token(str, optional):  The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. . Defaults to None.
        max_results(int, optional):  The number of entries a paginated response contains. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.cost.category.definition.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.cost.category.definition.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="list_cost_category_definitions",
        op_kwargs={
            "EffectiveOn": effective_on,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    cost_category_arn: str,
    rule_version: str,
    rules: List,
    default_value: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.

    Args:
        cost_category_arn(str): The unique identifier for your Cost Category.
        rule_version(str): The rule schema version in this particular Cost Category.
        rules(List): The Expression object used to categorize costs. For more information, see CostCategoryRule . .
        default_value(str, optional): The default value for the cost category. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.cost.category.definition.update(
                ctx, cost_category_arn=value, rule_version=value, rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.cost.category.definition.update cost_category_arn=value, rule_version=value, rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="update_cost_category_definition",
        op_kwargs={
            "CostCategoryArn": cost_category_arn,
            "RuleVersion": rule_version,
            "Rules": rules,
            "DefaultValue": default_value,
        },
    )
