"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, anomaly_subscription: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving notifications.

    Args:
        anomaly_subscription(Dict):  The cost anomaly subscription object that you want to create. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.anomaly.subscription.create(ctx, anomaly_subscription=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.anomaly.subscription.create anomaly_subscription=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="create_anomaly_subscription",
        op_kwargs={"AnomalySubscription": anomaly_subscription},
    )


async def delete(hub, ctx, subscription_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a cost anomaly subscription.

    Args:
        subscription_arn(str):  The unique identifier of the cost anomaly subscription that you want to delete. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.anomaly.subscription.delete(ctx, subscription_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.anomaly.subscription.delete subscription_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="delete_anomaly_subscription",
        op_kwargs={"SubscriptionArn": subscription_arn},
    )


async def get_all(
    hub,
    ctx,
    subscription_arn_list: List = None,
    monitor_arn: str = None,
    next_page_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).

    Args:
        subscription_arn_list(List, optional):  A list of cost anomaly subscription ARNs. . Defaults to None.
        monitor_arn(str, optional):  Cost anomaly monitor ARNs. . Defaults to None.
        next_page_token(str, optional):  The token to retrieve the next set of results. AWS provides the token when the response from a previous call has more results than the maximum page size. . Defaults to None.
        max_results(int, optional):  The number of entries a paginated response contains. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.anomaly.subscription.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.anomaly.subscription.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_anomaly_subscriptions",
        op_kwargs={
            "SubscriptionArnList": subscription_arn_list,
            "MonitorArn": monitor_arn,
            "NextPageToken": next_page_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    subscription_arn: str,
    threshold: float = None,
    frequency: str = None,
    monitor_arn_list: List = None,
    subscribers: List = None,
    subscription_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates an existing cost anomaly monitor subscription.

    Args:
        subscription_arn(str):  A cost anomaly subscription Amazon Resource Name (ARN). .
        threshold(float, optional):  The update to the threshold value for receiving notifications. . Defaults to None.
        frequency(str, optional):  The update to the frequency value at which subscribers will receive notifications. . Defaults to None.
        monitor_arn_list(List, optional):  A list of cost anomaly monitor ARNs. . Defaults to None.
        subscribers(List, optional):  The update to the subscriber list. . Defaults to None.
        subscription_name(str, optional):  The subscription's new name. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.anomaly.subscription.update(ctx, subscription_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.anomaly.subscription.update subscription_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="update_anomaly_subscription",
        op_kwargs={
            "SubscriptionArn": subscription_arn,
            "Threshold": threshold,
            "Frequency": frequency,
            "MonitorArnList": monitor_arn_list,
            "Subscribers": subscribers,
            "SubscriptionName": subscription_name,
        },
    )
