"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    date_interval: Dict,
    monitor_arn: str = None,
    feedback: str = None,
    total_impact: Dict = None,
    next_page_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all of the cost anomalies detected on your account, during the time period specified by the DateInterval object.

    Args:
        monitor_arn(str, optional): Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). . Defaults to None.
        date_interval(Dict): Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an AnomalyEndDate in the specified time range. .
        feedback(str, optional): Filters anomaly results by the feedback field on the anomaly object. . Defaults to None.
        total_impact(Dict, optional): Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies GREATER_THAN 200.00 to retrieve anomalies, with an estimated dollar impact greater than 200. . Defaults to None.
        next_page_token(str, optional):  The token to retrieve the next set of results. AWS provides the token when the response from a previous call has more results than the maximum page size. . Defaults to None.
        max_results(int, optional):  The number of entries a paginated response contains. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.anomaly.init.get_all(ctx, date_interval=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.anomaly.init.get_all date_interval=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="get_anomalies",
        op_kwargs={
            "MonitorArn": monitor_arn,
            "DateInterval": date_interval,
            "Feedback": feedback,
            "TotalImpact": total_impact,
            "NextPageToken": next_page_token,
            "MaxResults": max_results,
        },
    )
