"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def provide(hub, ctx, anomaly_id: str, feedback: str) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the feedback property of a given cost anomaly.

    Args:
        anomaly_id(str):  A cost anomaly ID. .
        feedback(str): Describes whether the cost anomaly was a planned activity or you considered it an anomaly. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ce.anomaly.feedback.provide(
                ctx, anomaly_id=value, feedback=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ce.anomaly.feedback.provide anomaly_id=value, feedback=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ce",
        operation="provide_anomaly_feedback",
        op_kwargs={"AnomalyId": anomaly_id, "Feedback": feedback},
    )
