"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, account_id: str, budget_name: str, notification: Dict, subscriber: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a subscriber. You must create the associated budget and notification before you create the subscriber.

    Args:
        account_id(str): The accountId that is associated with the budget that you want to create a subscriber for.
        budget_name(str): The name of the budget that you want to subscribe to. Budget names must be unique within an account.
        notification(Dict): The notification that you want to create a subscriber for.
        subscriber(Dict): The subscriber that you want to associate with a budget notification.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.subscriber.init.create(
                ctx, account_id=value, budget_name=value, notification=value, subscriber=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.subscriber.init.create account_id=value, budget_name=value, notification=value, subscriber=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="create_subscriber",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "Notification": notification,
            "Subscriber": subscriber,
        },
    )


async def delete(
    hub, ctx, account_id: str, budget_name: str, notification: Dict, subscriber: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a subscriber.  Deleting the last subscriber to a notification also deletes the notification.

    Args:
        account_id(str): The accountId that is associated with the budget whose subscriber you want to delete.
        budget_name(str): The name of the budget whose subscriber you want to delete.
        notification(Dict): The notification whose subscriber you want to delete.
        subscriber(Dict): The subscriber that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.subscriber.init.delete(
                ctx, account_id=value, budget_name=value, notification=value, subscriber=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.subscriber.init.delete account_id=value, budget_name=value, notification=value, subscriber=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="delete_subscriber",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "Notification": notification,
            "Subscriber": subscriber,
        },
    )


async def update(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    notification: Dict,
    old_subscriber: Dict,
    new_subscriber: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a subscriber.

    Args:
        account_id(str): The accountId that is associated with the budget whose subscriber you want to update.
        budget_name(str): The name of the budget whose subscriber you want to update.
        notification(Dict): The notification whose subscriber you want to update.
        old_subscriber(Dict): The previous subscriber that is associated with a budget notification.
        new_subscriber(Dict): The updated subscriber that is associated with a budget notification.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.subscriber.init.update(
                ctx,
                account_id=value,
                budget_name=value,
                notification=value,
                old_subscriber=value,
                new_subscriber=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.subscriber.init.update account_id=value, budget_name=value, notification=value, old_subscriber=value, new_subscriber=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="update_subscriber",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "Notification": notification,
            "OldSubscriber": old_subscriber,
            "NewSubscriber": new_subscriber,
        },
    )
