"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    notification: Dict,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the subscribers that are associated with a notification.

    Args:
        account_id(str): The accountId that is associated with the budget whose subscribers you want descriptions of.
        budget_name(str): The name of the budget whose subscribers you want descriptions of.
        notification(Dict): The notification whose subscribers you want to list.
        max_results(int, optional): An optional integer that represents how many entries a paginated response contains. The maximum is 100. Defaults to None.
        next_token(str, optional): The pagination token that you include in your request to indicate the next set of results that you want to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.subscriber.for_notification.describe(
                ctx, account_id=value, budget_name=value, notification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.subscriber.for_notification.describe account_id=value, budget_name=value, notification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_subscribers_for_notification",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "Notification": notification,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
