"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, account_id: str, budget_name: str, notification: Dict, subscribers: List
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a notification. You must create the budget before you create the associated notification.

    Args:
        account_id(str): The accountId that is associated with the budget that you want to create a notification for.
        budget_name(str): The name of the budget that you want AWS to notify you about. Budget names must be unique within an account.
        notification(Dict): The notification that you want to create.
        subscribers(List): A list of subscribers that you want to associate with the notification. Each notification can have one SNS subscriber and up to 10 email subscribers.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.notification.init.create(
                ctx, account_id=value, budget_name=value, notification=value, subscribers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.notification.init.create account_id=value, budget_name=value, notification=value, subscribers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="create_notification",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "Notification": notification,
            "Subscribers": subscribers,
        },
    )


async def delete(
    hub, ctx, account_id: str, budget_name: str, notification: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a notification.  Deleting a notification also deletes the subscribers that are associated with the notification.

    Args:
        account_id(str): The accountId that is associated with the budget whose notification you want to delete.
        budget_name(str): The name of the budget whose notification you want to delete.
        notification(Dict): The notification that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.notification.init.delete(
                ctx, account_id=value, budget_name=value, notification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.notification.init.delete account_id=value, budget_name=value, notification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="delete_notification",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "Notification": notification,
        },
    )


async def update(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    old_notification: Dict,
    new_notification: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a notification.

    Args:
        account_id(str): The accountId that is associated with the budget whose notification you want to update.
        budget_name(str): The name of the budget whose notification you want to update.
        old_notification(Dict): The previous notification that is associated with a budget.
        new_notification(Dict): The updated notification to be associated with a budget.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.notification.init.update(
                ctx,
                account_id=value,
                budget_name=value,
                old_notification=value,
                new_notification=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.notification.init.update account_id=value, budget_name=value, old_notification=value, new_notification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="update_notification",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "OldNotification": old_notification,
            "NewNotification": new_notification,
        },
    )
