"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    time_period: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the history for DAILY, MONTHLY, and QUARTERLY budgets. Budget history isn't available for ANNUAL budgets.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        time_period(Dict, optional): Retrieves how often the budget went into an ALARM state for the specified time period. Defaults to None.
        max_results(int, optional):  An integer that represents how many entries a paginated response contains. The maximum is 100. Defaults to None.
        next_token(str, optional):  A generic string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.performance_history.describe(
                ctx, account_id=value, budget_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.performance_history.describe account_id=value, budget_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_budget_performance_history",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "TimePeriod": time_period,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
