"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, account_id: str, budget: Dict, notifications_with_subscribers: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a budget and, if included, notifications and subscribers.   Only one of BudgetLimit or PlannedBudgetLimits can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples section.

    Args:
        account_id(str): The accountId that is associated with the budget.
        budget(Dict): The budget object that you want to create.
        notifications_with_subscribers(List, optional): A notification that you want to associate with a budget. A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your CreateBudget call, AWS creates the notifications and subscribers for you. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.init.create(ctx, account_id=value, budget=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.init.create account_id=value, budget=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="create_budget",
        op_kwargs={
            "AccountId": account_id,
            "Budget": budget,
            "NotificationsWithSubscribers": notifications_with_subscribers,
        },
    )


async def delete(hub, ctx, account_id: str, budget_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a budget. You can delete your budget at any time.  Deleting a budget also deletes the notifications and subscribers that are associated with that budget.

    Args:
        account_id(str): The accountId that is associated with the budget that you want to delete.
        budget_name(str): The name of the budget that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.init.delete(
                ctx, account_id=value, budget_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.init.delete account_id=value, budget_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="delete_budget",
        op_kwargs={"AccountId": account_id, "BudgetName": budget_name},
    )


async def describe(hub, ctx, account_id: str, budget_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a budget.  The Request Syntax section shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples section.

    Args:
        account_id(str): The accountId that is associated with the budget that you want a description of.
        budget_name(str): The name of the budget that you want a description of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.init.describe(
                ctx, account_id=value, budget_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.init.describe account_id=value, budget_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_budget",
        op_kwargs={"AccountId": account_id, "BudgetName": budget_name},
    )


async def describe_all(
    hub, ctx, account_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the budgets that are associated with an account.  The Request Syntax section shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples section.

    Args:
        account_id(str): The accountId that is associated with the budgets that you want descriptions of.
        max_results(int, optional): An optional integer that represents how many entries a paginated response contains. The maximum is 100. Defaults to None.
        next_token(str, optional): The pagination token that you include in your request to indicate the next set of results that you want to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.init.describe_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.init.describe_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_budgets",
        op_kwargs={
            "AccountId": account_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, account_id: str, new_budget: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates a budget. You can change every part of a budget except for the budgetName and the calculatedSpend. When you modify a budget, the calculatedSpend drops to zero until AWS has new usage data to use for forecasting.  Only one of BudgetLimit or PlannedBudgetLimits can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples section.

    Args:
        account_id(str): The accountId that is associated with the budget that you want to update.
        new_budget(Dict): The budget that you want to update your budget to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.init.update(
                ctx, account_id=value, new_budget=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.init.update account_id=value, new_budget=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="update_budget",
        op_kwargs={"AccountId": account_id, "NewBudget": new_budget},
    )
