"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    notification_type: str,
    action_type: str,
    action_threshold: Dict,
    definition: Dict,
    execution_role_arn: str,
    approval_model: str,
    subscribers: List,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a budget action.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        notification_type(str):  The type of a notification. It must be ACTUAL or FORECASTED.
        action_type(str):  The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. .
        action_threshold(Dict):  The trigger threshold of the action. .
        definition(Dict):  Specifies all of the type-specific parameters. .
        execution_role_arn(str):  The role passed for action execution and reversion. Roles and actions must be in the same account. .
        approval_model(str):  This specifies if the action needs manual or automatic approval. .
        subscribers(List):  A list of subscribers.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.init.create(
                ctx,
                account_id=value,
                budget_name=value,
                notification_type=value,
                action_type=value,
                action_threshold=value,
                definition=value,
                execution_role_arn=value,
                approval_model=value,
                subscribers=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.init.create account_id=value, budget_name=value, notification_type=value, action_type=value, action_threshold=value, definition=value, execution_role_arn=value, approval_model=value, subscribers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="create_budget_action",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "NotificationType": notification_type,
            "ActionType": action_type,
            "ActionThreshold": action_threshold,
            "Definition": definition,
            "ExecutionRoleArn": execution_role_arn,
            "ApprovalModel": approval_model,
            "Subscribers": subscribers,
        },
    )


async def delete(hub, ctx, account_id: str, budget_name: str, action_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a budget action.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        action_id(str):  A system-generated universally unique identifier (UUID) for the action. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.init.delete(
                ctx, account_id=value, budget_name=value, action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.init.delete account_id=value, budget_name=value, action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="delete_budget_action",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "ActionId": action_id,
        },
    )


async def describe(hub, ctx, account_id: str, budget_name: str, action_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Describes a budget action detail.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        action_id(str):  A system-generated universally unique identifier (UUID) for the action. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.init.describe(
                ctx, account_id=value, budget_name=value, action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.init.describe account_id=value, budget_name=value, action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_budget_action",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "ActionId": action_id,
        },
    )


async def execute(
    hub, ctx, account_id: str, budget_name: str, action_id: str, execution_type: str
) -> Dict:
    r"""
    **Autogenerated function**

     Executes a budget action.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        action_id(str):  A system-generated universally unique identifier (UUID) for the action. .
        execution_type(str):  The type of execution. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.init.execute(
                ctx, account_id=value, budget_name=value, action_id=value, execution_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.init.execute account_id=value, budget_name=value, action_id=value, execution_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="execute_budget_action",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "ActionId": action_id,
            "ExecutionType": execution_type,
        },
    )


async def update(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    action_id: str,
    notification_type: str = None,
    action_threshold: Dict = None,
    definition: Dict = None,
    execution_role_arn: str = None,
    approval_model: str = None,
    subscribers: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a budget action.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        action_id(str):  A system-generated universally unique identifier (UUID) for the action. .
        notification_type(str, optional):  The type of a notification. It must be ACTUAL or FORECASTED. Defaults to None.
        action_threshold(Dict, optional):  The trigger threshold of the action. . Defaults to None.
        definition(Dict, optional):  Specifies all of the type-specific parameters. . Defaults to None.
        execution_role_arn(str, optional):  The role passed for action execution and reversion. Roles and actions must be in the same account. . Defaults to None.
        approval_model(str, optional):  This specifies if the action needs manual or automatic approval. . Defaults to None.
        subscribers(List, optional):  A list of subscribers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.init.update(
                ctx, account_id=value, budget_name=value, action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.init.update account_id=value, budget_name=value, action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="update_budget_action",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "ActionId": action_id,
            "NotificationType": notification_type,
            "ActionThreshold": action_threshold,
            "Definition": definition,
            "ExecutionRoleArn": execution_role_arn,
            "ApprovalModel": approval_model,
            "Subscribers": subscribers,
        },
    )
