"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    account_id: str,
    budget_name: str,
    action_id: str,
    time_period: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Describes a budget action history detail.

    Args:
        account_id(str): The account ID of the user. It should be a 12-digit number.
        budget_name(str):  A string that represents the budget name. The ":" and "\" characters aren't allowed.
        action_id(str):  A system-generated universally unique identifier (UUID) for the action. .
        time_period(Dict, optional): The period of time that is covered by a budget. The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date. . Defaults to None.
        max_results(int, optional):  An integer that represents how many entries a paginated response contains. The maximum is 100. Defaults to None.
        next_token(str, optional):  A generic string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.budget.budget.action.history.describe_all(
                ctx, account_id=value, budget_name=value, action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.budget.budget.action.history.describe_all account_id=value, budget_name=value, action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="budgets",
        operation="describe_budget_action_histories",
        op_kwargs={
            "AccountId": account_id,
            "BudgetName": budget_name,
            "ActionId": action_id,
            "TimePeriod": time_period,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
